# 로드 밸런싱(Load Balancing)

- 서버가 처리해야 할 요청을 여러 대의 서버로 적절히 분배하여 처리하는 것을 의미한다.  
- 한 대의 서버로 부하가 집중되지 않도록 트래픽*을 관리해 각각의 서버가 최적의 성능을 보일 수 있도록 하는 것이 목적이다.

    **트래픽 : 서버와 스위치 등 네트워크 장치에서 일정 시간 내에 흐르는 데이터의 양*

</br>

<img width="500" alt="스크린샷 2022-12-18 오후 2 00 09" src="https://user-images.githubusercontent.com/70997596/208283195-8ac409d6-3c01-4aee-9e75-6f2bee13b5a9.png">

</br>

서비스의 규모가 커지고, 이용자 수가 늘어나면 기존의 서버만으로는 원활한 서비스 운영이 불가능하게 되고, 이에 대처할 수 있는 방법은 크게 두 가지로 나뉜다.

- 기존의 서버 성능을 확장하는 **Scale-up** 방식
- 기존의 서버와 동일하거나 낮은 성능의 서버를 증설하는 **Scale-out** 방식

이때 Scale-out 방식을 통해 증가한 트래픽에 대처하기로 했다면, 여러 대의 서버로 트래픽을 균등하게 분산해주는 **로드 밸런싱**이 반드시 필요하다.

</br>

## 로드 밸런싱 기법

로드 밸런싱 기법은 여러 가지가 있다. 서버의 능력을 고려하여 분배해야 하기 때문에, 서버의 상황에 맞춰 적절한 방법을 선택해야 한다.  
- **라운드 로빈 방식(Round Robin Method)**
    - 서버에 들어온 요청을 순서대로 돌아가며 배정하는 방식이다.  
    - 클라이언트의 요청을 순서대로 분배하기 때문에 여러 대의 서버가 동일한 스펙을 갖고 있고,  
      서버와의 연결(세션)이 오래 지속되지 않는 경우에 활용하기 적합하다.

</br> 

- **가중 라운드로빈 방식(Weighted Round Robin Method)**
    - 각각의 서버마다 처리 능력에 따른 가중치를 부여하고, 가중치가 높은 서버에 들어온 요청을 우선적으로 배분한다.  
    - 주로 서버간의 트래픽 처리 능력이 상이한 경우 사용되는 부하 분산 방식이다.
 
</br>

- **IP 해시 방식(IP Hash Method)**
    - 클라이언트의 IP 주소를 특정 서버로 매핑하여 요청을 처리하는 방식이다.  
    - 사용자의 IP를 해싱해 요청을 분배하기 때문에 사용자가 항상 동일한 서버로 연결되는 것을 보장한다.
 
</br>

- **최소 연결 방식(Least Connection Method)**
    - 요청이 들어온 시점에 가장 적은 연결 상태를 보이는 서버에 우선적으로 트래픽을 배분한다.  
    - 자주 세션이 길어지거나, 서버에 분배된 트래픽들이 일정하지 않은 경우에 적합한 방식이다.
 
</br>


- **최소 응답 시간 방식(Least Response Time Method)**
    - 서버의 현재 연결 상태와 응답 시간*을 모두 고려하여 가장 짧은 응답 시간을 보이는 서버에 우선적으로 요청을 배분하는 방식이다.
    - 각 서버들의 가용한 자원과 성능, 처리 중인 데이터의 양 등이 상이한 경우에 적합한 방식이다.
      
        **응답 시간 : 서버에 요청을 보내고 최초 응답을 받을 때까지 소요되는 시간*

</br>

## 로드 밸런서

- 로드밸런서는 트래픽을 받아 여러 대의 서버에 분산 시키는, 즉 로드밸런싱을 수행하는 하드웨어 혹은 소프트웨어이다.
- L4 로드밸런서부터 포트 정보를 바탕으로 요청들을 분산하는 것이 가능하기 때문에 로드 밸런싱에는 L4 로드밸런서와 L7 로드밸런서가 가장 많이 활용된다.  
- 한 대의 서버에 각각 다른 포트 번호를 부여하여 다수의 서버 프로그램을 운영하는 경우에는 최소 L4 로드밸런서 이상을 사용해야 한다.
  
</br>

> **L4, L7**  
네트워크 통신 시스템은 크게 일곱 가지의 계층(OSI 7 layers)으로 나뉘고, 각각의 계층(Layer)이 L1/L2/L3‥‥L7에 해당한다.  
상위 계층에서 사용되는 장비는 하위 계층의 장비가 갖고 있는 기능을 모두 가지고 있으며, 상위 계층으로 갈수록 더욱 정교한 로드밸런싱이 가능하다.  
L4, L7은 각각 Layer 4(전송 계층) 프로토콜과 Layer 7(응용 계층) 프로토콜의 헤더를 이용하여 로드밸런싱을 하기 때문에 붙은 접두사이다.

</br>

### L4 로드 밸런서

- **L4 로드 밸런서**는 네트워크 계층(IP, IPX)이나 전송 계층(TCP, UDP)의 정보를 바탕으로 요청을 분산한다.
- 즉, IP주소, 포트번호, MAC주소, 전송 프로토콜 등에 따라 트래픽을 분산하는 것이 가능하다.

</br>

<img width="650" alt="스크린샷 2022-12-18 오후 2 33 32" src="https://user-images.githubusercontent.com/70997596/208283239-b255d0c7-de1c-40ec-a178-2d880e1e0c75.png">  

</br>

### L7 로드 밸런서

- **L7 로드 밸런서**는 애플리케이션 계층위에서 동작하기 때문에 IP, 포트번호 외에도 **URI, HTTP 헤더, 쿠키** 등의 내용을 기준으로 특정 서버에 트래픽을 분산하는 것이 가능하다.  
- L4 로드밸런서와 달리 패킷의 내용을 확인하고 그 내용에 따라 요청을 특정 서버에 분배하는 것이다.  
- 내용을 분석해서 처리하기 때문에 클라이언트의 요청을 보다 세분화하여 서버에 전달할 수 있다.  
- 또한 특정한 패턴을 지닌 바이러스를 감지해 네트워크를 보호할 수 있으며, DoS/DDoS와 같은 비정상적인 트래픽을 필터링할 수 있어 네트워크 보안 분야에서도 활용되고 있다.

</br>

<img width="650" alt="스크린샷 2022-12-18 오후 2 33 50" src="https://user-images.githubusercontent.com/70997596/208283271-e546a9a6-f073-41bd-aa9b-57c618879df5.png"> 

</br>

### L4 vs L7 로드 밸런서 비교

<img width="700" alt="스크린샷 2022-12-18 오후 2 13 07" src="https://user-images.githubusercontent.com/70997596/208283230-86af1ec7-d985-4d01-bb8f-4975467202e6.png">

</br>

## 출처
- https://tecoble.techcourse.co.kr/post/2021-11-07-load-balancing/  
- https://nesoy.github.io/articles/2018-06/Load-Balancer
- https://dodghek.tistory.com/33

